unit Question3_u;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, Buttons, Math;

type
  TfrmSchools = class(TForm)
    btnDisplay: TButton;
    BitBtn1: TBitBtn;
    redOutput: TRichEdit;
    btnSearch: TButton;
    btnSort: TButton;
    btnCode: TButton;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    GroupBox3: TGroupBox;
    GroupBox4: TGroupBox;
    procedure FormActivate(Sender: TObject);
    procedure btnDisplayClick(Sender: TObject);
    procedure btnSearchClick(Sender: TObject);
    procedure btnSortClick(Sender: TObject);

    procedure btnCodeClick(Sender: TObject);

  private

    procedure DisplayArrays(sHeading: String);
    function GenerateCode(sSchoolName: String): String;

  public
    { Public declarations }
  end;

var
  frmSchools: TfrmSchools;

  arrSchools: array [1 .. 10] of String = (
    'Gordon High School',
    'Paul Roos Gymnasium',
    'Parel Vallei High School',
    'Horskool Strand',
    'Horskool Bloemhof',
    'Khanyolwethu High School',
    'Rhenish Girls'' High School',
    'Macassar High School',
    'Hottentots Holland High School',
    'Horskool Stellenbosch'
  );

  arrNumGymnasts: array [1 .. 10] of Integer = (
    23,
    38,
    42,
    31,
    18,
    35,
    21,
    26,
    40,
    34
  );

implementation

{$R *.dfm}

procedure TfrmSchools.btnCodeClick(Sender: TObject);
var
  I: Integer;
  sCode: String;
begin
  redOutput.Clear;
  redOutput.Lines.Add('The codes for the schools:' + #13);
  for I := 1 to 10 do
  begin
    sCode := GenerateCode(arrSchools[I]);
    redOutput.Lines.Add(arrSchools[i] + #9 + sCode);
  end;
end;

procedure TfrmSchools.btnDisplayClick(Sender: TObject);
var
  I, iTotal: Integer;
begin
  DisplayArrays('The schools participating:');
  iTotal := 0;
  for I := 1 to 10 do
  begin
    Inc(iTotal, arrNumGymnasts[I]);
  end;
  redOutput.Lines.Add(#13 + 'The total number of gymnasts: ' + #9 + IntToStr
      (iTotal));
end;

procedure TfrmSchools.btnSearchClick(Sender: TObject);
var
  I: Integer;
  sFind: String;
  bFlag: Boolean;
begin
  redOutput.Clear;

  bFlag := false;
  sFind := InputBox('Search', 'Enter the name of the school:', '');
  I := 1;
  while (NOT bFlag) AND (I <= 10) do
  begin
    if (UpperCase(sFind) = UpperCase(arrSchools[I])) then
    begin
      bFlag := true;
      redOutput.Lines.Add(sFind + ' has ' + IntToStr(arrNumGymnasts[I])
          + ' learners competing');
    end
    else
      Inc(I);
  end;
  if NOT bFlag then
    redOutput.Lines.Add(sFind + ' was not found');

end;

procedure TfrmSchools.btnSortClick(Sender: TObject);
var
  I, j, iTemp: Integer;
  sTemp: String;
begin
  for I := 1 to 9 do
  begin
    for j := I + 1 to 10 do
    begin
      if arrNumGymnasts[I] > arrNumGymnasts[j] then
      begin
        iTemp := arrNumGymnasts[I];
        arrNumGymnasts[I] := arrNumGymnasts[j];
        arrNumGymnasts[j] := iTemp;

        sTemp := arrSchools[I];
        arrSchools[I] := arrSchools[j];
        arrSchools[j] := sTemp;
      end;
    end;

  end;
  redOutput.Clear;
  DisplayArrays('The schools in order of number of gymnasts');
end;


procedure TfrmSchools.DisplayArrays(sHeading: String);
var
  I: Integer;
begin
  redOutput.Lines.Add(sHeading + #13);
  for I := 1 to 10 do
  begin
    redOutput.Lines.Add(arrSchools[I] + #9 + IntToStr(arrNumGymnasts[I]));
  end;

end;

procedure TfrmSchools.FormActivate(Sender: TObject);
begin
  redOutput.Paragraph.TabCount := 1;
  redOutput.Paragraph.Tab[0] := 120;
end;

function TfrmSchools.GenerateCode(sSchoolName: String): String;
var
  sCode: String;
  I: Integer;
begin
  sCode := sSchoolName[1];

  for I := 1 to Length(sSchoolName) do
  begin
    if sSchoolName[I] = ' ' then
      sCode := sCode + sSchoolName[I + 1];
  end;

  Result := sCode + IntToStr(RandomRange(100, 1000));
end;

end.
